# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_task_maker_tools_global_optspecs
	string join \n v/verbose h/help
end

function __fish_task_maker_tools_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_task_maker_tools_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_task_maker_tools_using_subcommand
	set -l cmd (__fish_task_maker_tools_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -s v -l verbose -d 'Verbose mode (-v, -vv, -vvv, etc.). Note that it does not play well with curses ui'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -s h -l help -d 'Print help'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "clear" -d 'Clear a task directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "gen-autocompletion" -d 'Generate the autocompletion files for the shell'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "server" -d 'Spawn an instance of the server'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "worker" -d 'Spawn an instance of a worker'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "reset" -d 'Wipe the internal storage of task-maker'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "sandbox" -d 'Run a command inside a sandbox similar to the one used by task-maker'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "task-info" -d 'Obtain the information about a task'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "booklet" -d 'Compile just the booklet for a task or a contest'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "copy-competition-files" -d 'Copy statements and attachments of a contest in a separate directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "terry-statement" -d 'Build terry statements by adding the subtask table'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "fuzz-checker" -d 'Fuzz the checker of a task'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "find-bad-case" -d 'Generate and search for an input file that make a solution fail'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "add-solution-checks" -d 'Add the @check comments to the solutions'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "export-solution-checks" -d 'Exports solution checks to json'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "export-booklet" -d 'Exports internal booklet structure as a zip'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "internal-sandbox" -d 'Run the sandbox instead of the normal task-maker'
complete -c task-maker-tools -n "__fish_task_maker_tools_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand clear" -s t -l task-dir -d 'Directory of the task' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand clear" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand clear" -s h -l help -d 'Print help'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand gen-autocompletion" -s t -l target -d 'Where to write the autocompletion files' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand gen-autocompletion" -s h -l help -d 'Print help'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand server" -l client-password -d 'Password for the connection of the clients' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand server" -l worker-password -d 'Password for the connection of the workers' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand server" -l store-dir -d 'Where to store the storage files, including the cache' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand server" -l max-cache -d 'Maximum size of the storage directory, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand server" -l min-cache -d 'When the storage is flushed, this is the new maximum size, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand server" -s h -l help -d 'Print help'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand worker" -l name -d 'The name to use for the worker in remote executions' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand worker" -l store-dir -d 'Where to store the storage files, including the cache' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand worker" -l max-cache -d 'Maximum size of the storage directory, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand worker" -l min-cache -d 'When the storage is flushed, this is the new maximum size, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand worker" -s h -l help -d 'Print help'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand reset" -l store-dir -d 'Where to store the storage files, including the cache' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand reset" -l max-cache -d 'Maximum size of the storage directory, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand reset" -l min-cache -d 'When the storage is flushed, this is the new maximum size, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand reset" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -s w -l workdir -d 'Working directory of the sandbox' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -s m -l memory-limit -d 'Memory limit for the sandbox, in KiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -s s -l stack-limit -d 'Stack limit for the sandbox, in KiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -s r -l readable-dirs -d 'List of additional directory mounted read-only inside the sandbox' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -l uid -d 'User id' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -l gid -d 'User id' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -l single-process -d 'Prevent forking'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -l mount-tmpfs -d 'Mount /tmp and /dev/null inside the sandbox'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -l mount-proc -d 'Mount /proc inside the sandbox'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand sandbox" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand task-info" -s t -l task-dir -d 'Directory of the task' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand task-info" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand task-info" -s j -l json -d 'Produce JSON output'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand task-info" -s h -l help -d 'Print help'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -s c -l contest-dir -d 'Directory of the contest' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -s t -l task-dir -d 'Directory of the task' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l ui -d 'Which UI to use, available UIs are: print, raw, curses, json' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l no-cache -d 'Disable the cache for this comma separated list of tags' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l extra-time -d 'Give to the solution some extra time before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l extra-memory -d 'Give to the solution some extra memory before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l num-cores -d 'The number of CPU cores to use' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l evaluate-on -d 'Run the evaluation on a remote server instead of locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l name -d 'The name to use for the client in remote executions' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l priority -d 'Priority of the evaluations spawned by this invocation of task-maker; no effect if running locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l store-dir -d 'Where to store the storage files, including the cache' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l max-cache -d 'Maximum size of the storage directory, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l min-cache -d 'When the storage is flushed, this is the new maximum size, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l booklet-solutions -d 'Include the solutions in the booklet'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l keep-sandboxes -d 'Keep all the sandbox directories'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l dry-run -d 'Do not write any file inside the task directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l copy-exe -d 'Copy the executables to the bin/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l copy-logs -d 'Copy the logs of some executions to the bin/logs/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -l copy-dag -d 'Store the DAG in DOT format inside of bin/DAG.dot'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand booklet" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -s c -l contest-dir -d 'Directory of the context' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l ui -d 'Which UI to use, available UIs are: print, raw, curses, json' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l no-cache -d 'Disable the cache for this comma separated list of tags' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l extra-time -d 'Give to the solution some extra time before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l extra-memory -d 'Give to the solution some extra memory before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l num-cores -d 'The number of CPU cores to use' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l evaluate-on -d 'Run the evaluation on a remote server instead of locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l name -d 'The name to use for the client in remote executions' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l priority -d 'Priority of the evaluations spawned by this invocation of task-maker; no effect if running locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l store-dir -d 'Where to store the storage files, including the cache' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l max-cache -d 'Maximum size of the storage directory, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l min-cache -d 'When the storage is flushed, this is the new maximum size, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l keep-sandboxes -d 'Keep all the sandbox directories'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l dry-run -d 'Do not write any file inside the task directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l copy-exe -d 'Copy the executables to the bin/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l copy-logs -d 'Copy the logs of some executions to the bin/logs/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -l copy-dag -d 'Store the DAG in DOT format inside of bin/DAG.dot'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand copy-competition-files" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand terry-statement" -s s -l statement-path -d 'Path to statement template (uses task directory structure if omitted)' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand terry-statement" -s t -l subtasks-path -d 'Path to subtasks file (none if omitted)' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand terry-statement" -s o -l output-path -d 'Path to store output statement (stdout if omitted)' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand terry-statement" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand terry-statement" -s h -l help -d 'Print help'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -s t -l task-dir -d 'Directory of the task' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l fuzz-dir -d 'Where to store fuzzing data' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l sanitizers -d 'Additional sanitizers to use' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -s j -l jobs -d 'Number of fuzzing process to spawn' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l checker-timeout -d 'Maximum number of seconds the checker can run' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l max-time -d 'Maximum fuzzing time in seconds' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l no-cache -d 'Disable the cache for this comma separated list of tags' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l extra-time -d 'Give to the solution some extra time before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l extra-memory -d 'Give to the solution some extra memory before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l num-cores -d 'The number of CPU cores to use' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l evaluate-on -d 'Run the evaluation on a remote server instead of locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l name -d 'The name to use for the client in remote executions' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l priority -d 'Priority of the evaluations spawned by this invocation of task-maker; no effect if running locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l store-dir -d 'Where to store the storage files, including the cache' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l max-cache -d 'Maximum size of the storage directory, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l min-cache -d 'When the storage is flushed, this is the new maximum size, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l quiet -d 'Don\'t print the fuzzer output to the console, but redirect it to a file'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l no-build -d 'Don\'t run the evaluation for building the output files'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l keep-sandboxes -d 'Keep all the sandbox directories'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l dry-run -d 'Do not write any file inside the task directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l copy-exe -d 'Copy the executables to the bin/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l copy-logs -d 'Copy the logs of some executions to the bin/logs/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -l copy-dag -d 'Store the DAG in DOT format inside of bin/DAG.dot'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand fuzz-checker" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -s t -l task-dir -d 'Directory of the task' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l no-cache -d 'Disable the cache for this comma separated list of tags' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l extra-time -d 'Give to the solution some extra time before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l extra-memory -d 'Give to the solution some extra memory before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l num-cores -d 'The number of CPU cores to use' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l evaluate-on -d 'Run the evaluation on a remote server instead of locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l name -d 'The name to use for the client in remote executions' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l priority -d 'Priority of the evaluations spawned by this invocation of task-maker; no effect if running locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l store-dir -d 'Where to store the storage files, including the cache' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l max-cache -d 'Maximum size of the storage directory, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l min-cache -d 'When the storage is flushed, this is the new maximum size, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -s b -l batch-size -d 'Number of input files to generate for each batch' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l keep-sandboxes -d 'Keep all the sandbox directories'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l dry-run -d 'Do not write any file inside the task directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l copy-exe -d 'Copy the executables to the bin/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l copy-logs -d 'Copy the logs of some executions to the bin/logs/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -l copy-dag -d 'Store the DAG in DOT format inside of bin/DAG.dot'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand find-bad-case" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -s t -l task-dir -d 'Directory of the task' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l ui -d 'Which UI to use, available UIs are: print, raw, curses, json' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l store-dir -d 'Where to store the storage files, including the cache' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l max-cache -d 'Maximum size of the storage directory, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l min-cache -d 'When the storage is flushed, this is the new maximum size, in MiB' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -s s -l solution -d 'Evaluate only the solution with the specified path' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l no-cache -d 'Disable the cache for this comma separated list of tags' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l extra-time -d 'Give to the solution some extra time before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l extra-memory -d 'Give to the solution some extra memory before being killed' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l num-cores -d 'The number of CPU cores to use' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l evaluate-on -d 'Run the evaluation on a remote server instead of locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l name -d 'The name to use for the client in remote executions' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l priority -d 'Priority of the evaluations spawned by this invocation of task-maker; no effect if running locally' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l keep-sandboxes -d 'Keep all the sandbox directories'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l dry-run -d 'Do not write any file inside the task directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l copy-exe -d 'Copy the executables to the bin/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l copy-logs -d 'Copy the logs of some executions to the bin/logs/ folder'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -l copy-dag -d 'Store the DAG in DOT format inside of bin/DAG.dot'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -s i -l in-place -d 'Write the @check directly to the solution files'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -s o -l overwrite -d 'Overwrite existing @check rules'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand add-solution-checks" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-solution-checks" -s t -l task-dir -d 'Directory of the task' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-solution-checks" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-solution-checks" -s s -l solution -d 'Evaluate only the solution with the specified path' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-solution-checks" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-booklet" -s c -l contest-dir -d 'Directory of the contest' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-booklet" -s t -l task-dir -d 'Directory of the task' -r -F
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-booklet" -l max-depth -d 'Look at most for this number of parents for searching the task' -r
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-booklet" -l booklet-solutions -d 'Include the solutions in the booklet'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand export-booklet" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand internal-sandbox" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "clear" -d 'Clear a task directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "gen-autocompletion" -d 'Generate the autocompletion files for the shell'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "server" -d 'Spawn an instance of the server'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "worker" -d 'Spawn an instance of a worker'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "reset" -d 'Wipe the internal storage of task-maker'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "sandbox" -d 'Run a command inside a sandbox similar to the one used by task-maker'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "task-info" -d 'Obtain the information about a task'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "booklet" -d 'Compile just the booklet for a task or a contest'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "copy-competition-files" -d 'Copy statements and attachments of a contest in a separate directory'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "terry-statement" -d 'Build terry statements by adding the subtask table'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "fuzz-checker" -d 'Fuzz the checker of a task'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "find-bad-case" -d 'Generate and search for an input file that make a solution fail'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "add-solution-checks" -d 'Add the @check comments to the solutions'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "export-solution-checks" -d 'Exports solution checks to json'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "export-booklet" -d 'Exports internal booklet structure as a zip'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "internal-sandbox" -d 'Run the sandbox instead of the normal task-maker'
complete -c task-maker-tools -n "__fish_task_maker_tools_using_subcommand help; and not __fish_seen_subcommand_from clear gen-autocompletion server worker reset sandbox task-info booklet copy-competition-files terry-statement fuzz-checker find-bad-case add-solution-checks export-solution-checks export-booklet internal-sandbox help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
